/*
Freeze Transform MacroScript File



Author :   Frederick Ruff

Revision History:
	
	Dec 1 2000, created
	
	Aug 22 2003, Larry Minton
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
    08 mar 2006, Michael Zyracki
	    added support for Animation Layers, by disabling  Freezes over layers, and making sure zero
		keys are set on active layers.
	2015/1/20 add an appdatachunk to the first layer created by this utility as an internal flag
		so that we could know in the xref update process if we need to update this layer or not.
	2015/1/28 Chengqing: try to reuse the previous active layer since the xyz values of this layer are likely to 
		be published and if we always create new, those published values will not work and have to be re-published.
This script adds tools for freezing a transform
This is done via adding a second controller to the controllers stack.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
*/
macroScript FreezeTransform
	ButtonText:~FREEZETRANSFORM_BUTTONTEXT~  	
	Category:~FREEZETRANSFORM_CATEGORY~  	
	internalCategory:"Animation Tools"  	
	Tooltip:~FREEZETRANSFORM_TOOLTIP~  
( 	
	fn FreezeTransform = 	
	( 		
		local Obj = Selection as array 	
		suspendEditing
		for i = 1 to Obj.count do 		
		( 
			Try
			(	
				local CurObj = Obj[i] 	
				local curRotCtrl = CurObj.rotation.controller
				if  classof curRotCtrl != Rotation_Layer do
				(
					local activeCtrl = undefined
					if (classof curRotCtrl == Rotation_list) do 
					(
						if (curRotCtrl.getCount() == 2 and curRotCtrl.getActive() == 2 and classof curRotCtrl[2].controller == Euler_Xyz) do
						(
							activeCtrl = curRotCtrl[2]
						)
					)

					-- freeze rotation		
					CurObj.rotation.controller = Euler_Xyz()
					CurObj.rotation.controller = Rotation_list() 
					if (activeCtrl != undefined) then
					(
						activeCtrl.x_rotation = 0
						activeCtrl.y_rotation = 0
						activeCtrl.z_rotation = 0
						CurObj.rotation.controller.available.controller = activeCtrl.controller
					)
					else
					(
						CurObj.rotation.controller.available.controller = Euler_xyz() 		
					)
					
					/* "Localization on" */  
				
					CurObj.rotation.controller.setname 1 ~CUROBJ_SETNAME_FROZEN_ROTATION~ 		
					CurObj.rotation.controller.setname 2 ~CUROBJ_ZERO_EULER_XYZ_CAPTION~ 		
				
					/* "Localization off" */ 
					
					CurObj.rotation.controller.SetActive 2

					setAppData (CurObj.rotation.controller[1].controller) 0x100 "InternalFlagByFreezeTransform"
				)
				
				local curPosCtrl = CurObj.position.controller
				if classof curPosCtrl != Position_Layer do
				(
					local activeCtrl = undefined
					if (classof curPosCtrl == position_list) do 
					(
						if (curPosCtrl.getCount() == 2 and curPosCtrl.getActive() == 2 and classof curPosCtrl[2].controller == Position_XYZ) do
						(
							activeCtrl = curPosCtrl[2]
						)
					)
					-- freeze position
					CurObj.position.controller = Bezier_Position() 			
					CurObj.position.controller = position_list() 
					if (activeCtrl != undefined) then
					(						
						activeCtrl.x_position = 0
						activeCtrl.y_position = 0
						activeCtrl.z_position = 0
						CurObj.position.controller.available.controller = activeCtrl.controller
					)
					else
					(
						CurObj.position.controller.available.controller = Position_XYZ() 
					)
						
					/* "Localization on" */  
							
					CurObj.position.controller.setname 1 ~CUROBJ_FROZEN_POSITION_CAPTION~ 	
					CurObj.position.controller.setname 2 ~CUROBJ_ZERO_POS_XYZ~ 			
					
					/* "Localization off" */  
					
					CurObj.position.controller.SetActive 2 		
		
					-- position to zero
					CurObj.Position.controller[2].x_Position = 0
					CurObj.Position.controller[2].y_Position = 0
					CurObj.Position.controller[2].z_Position = 0

					setAppData (CurObj.position.controller[1].controller) 0x100 "InternalFlagByFreezeTransform"
				)
			)	
			/* "Localization on" */  
					
			Catch( messagebox ~MSGBOX_FAILURE_WHILE_FREEZING_AN_OBJ_TRANSFORM~ title:~MSGBOX_FAILURE_WHILE_FREEZING_AN_OBJ_TRANSFORM_TITLE~)
					
			/* "Localization off" */  	
		)
		resumeEditing
	)
	
	/* "Localization on" */  
	
	if querybox ~QUERYBOX_FREEZING_TRANSFORM_INVOLVES~ title:~FREEZE_TRANSFORMS_TITLE~ == true do 
	
	/* "Localization off" */
  
	FreezeTransform()

 )
 -- Set Transform to Zero
MacroScript TransformToZero
	ButtonText:~TRANSFORMTOZERO_BUTTONTEXT~ 
	Category:~TRANSFORMTOZERO_CATEGORY~ 
	internalCategory:"Animation Tools" 
	Tooltip:~TRANSFORMTOZERO_TOOLTIP~ 
(
	fn TransformToZero =
	(
	
		local Obj = Selection as array
		suspendEditing
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				if classof CurObj.Position.controller == Position_Layer then
				(
					local active = CurObj.position.controller.active
					CurObj.Position.controller[active].value = (Point3 0 0 0)
				)
				else
				(
					CurObj.Position.controller[2].x_Position = 0
					CurObj.Position.controller[2].y_Position = 0
					CurObj.Position.controller[2].z_Position = 0
				)

				if classof CurObj.rotation.controller == Rotation_Layer then
				(
					local active = CurObj.rotation.controller.active
				  	CurObj.rotation.controller[active].value = (quat 0 0 0 1)
				)
				else
				(
					CurObj.rotation.controller[2].x_rotation = 0
					CurObj.rotation.controller[2].y_rotation = 0
					CurObj.rotation.controller[2].z_rotation = 0
				)	
			)
			/* "Localization on" */  
			
			Catch( messagebox ~MSGBOX_ONE_OBJ_TRANSFORM_NEVER_FROZEN~ title:~MSGBOX_ONE_OBJ_TRANSFORM_NEVER_FROZEN_TITLE~)
			
			/* "Localization off" */  	
		)
		resumeEditing
		select Obj
	)

	TransformToZero()
)
 -- Freeze Rotation Only
 macroScript FreezeRotation
	ButtonText:~FREEZEROTATION_BUTTONTEXT~  	
	Category:~FREEZEROTATION_CATEGORY~  	
	internalCategory:"Animation Tools"  	
	Tooltip:~FREEZEROTATION_TOOLTIP~  
( 	
	fn FreezeRotation = 	
	( 		
		local Obj = Selection as array
		suspendEditing
		for i = 1 to Obj.count do 		
		( 	
			Try
			(		
				local CurObj = Obj[i] 
				local curRotCtrl = CurObj.rotation.controller
				if classof curRotCtrl != Rotation_Layer do
				(
					local activeCtrl = undefined
					if (classof curRotCtrl == Rotation_list) do 
					(
						if (curRotCtrl.getCount() == 2 and curRotCtrl.getActive() == 2 and classof curRotCtrl[2].controller == Euler_Xyz) do
						(
							activeCtrl = curRotCtrl[2]
						)
					)
					
					CurObj.rotation.controller = Euler_Xyz() 		
					CurObj.rotation.controller = Rotation_list() 		
					if (activeCtrl != undefined) then
					(
						activeCtrl.x_rotation = 0
						activeCtrl.y_rotation = 0
						activeCtrl.z_rotation = 0
						CurObj.rotation.controller.available.controller = activeCtrl.controller
					)
					else
					(
						CurObj.rotation.controller.available.controller = Euler_xyz()
					)
					/* "Localization on" */
		  
					CurObj.rotation.controller.setname 1 ~CUROBJ_ROTATION_INIT_INITIAL_POSE~ 		
					CurObj.rotation.controller.setname 2 ~CUROBJ_KEYFRAME_XYZ~ 		
					CurObj.rotation.controller.SetActive 2 

					setAppData (CurObj.rotation.controller[1].controller) 0x100 "InternalFlagByFreezeTransform"
				)
				
				/* "Localization off" */  
			)
			
			/* "Localization on" */  
			
			Catch( messagebox ~MSGBOX_FAILURE_OCCURED_WHILE_FREEZING_AN_OBJ_ROTATION~ title:~MSGBOX_FAILURE_OCCURED_WHILE_FREEZING_AN_OBJ_ROTATION_TITLE~)
			
			/* "Localization off" */  	
		)
		resumeEditing
		select Obj 
	) 
	
	FreezeRotation()
 )
 
 -- Freeze Position only
macroScript FreezePosition
	ButtonText:~FREEZEPOSITION_BUTTONTEXT~  	
	Category:~FREEZEPOSITION_CATEGORY~  	
	internalCategory:"Animation Tools"  	
	Tooltip:~FREEZEPOSITION_TOOLTIP~  
( 	
	fn FreezePosition = 	
	( 		
		local Obj = Selection as array
		suspendEditing		
		for i = 1 to Obj.count do 		
		(
			Try
			(
				local CurObj = Obj[i] 	
				local curPosCtrl = CurObj.position.controller
				if classof curPosCtrl !=  Position_Layer do
				(
					local activeCtrl = undefined
					if (classof curPosCtrl == position_list) do 
					(
						if (curPosCtrl.getCount() == 2 and curPosCtrl.getActive() == 2 and classof curPosCtrl[2].controller == Position_XYZ) do
						(
							activeCtrl = curPosCtrl[2]
						)
					)
					-- freeze position		
					CurObj.position.controller = Bezier_Position() 			
					CurObj.position.controller = position_list() 			
					if (activeCtrl != undefined) then
					(						
						activeCtrl.x_position = 0
						activeCtrl.y_position = 0
						activeCtrl.z_position = 0
						CurObj.position.controller.available.controller = activeCtrl.controller
					)
					else
					(
						CurObj.position.controller.available.controller = Position_XYZ() 
					)
					/* "Localization on" */
		  
					CurObj.position.controller.setname 1 ~CUROBJ_POSITION_CONTROLLER_INITIAL_POSE~ 									
					CurObj.position.controller.setname 2 ~CUROBJ_POSITION_CONTROLLER_KEYFRAME_XYZ~ 			
					CurObj.position.controller.SetActive 2 		
				
					/* "Localization off" */  	
					
					-- position to zero
					CurObj.Position.controller[2].x_Position = 0
					CurObj.Position.controller[2].y_Position = 0
					CurObj.Position.controller[2].z_Position = 0

					setAppData (CurObj.Position.controller[1].controller) 0x100 "InternalFlagByFreezeTransform"
				)
			)
			
			/* "Localization on" */  
			
			Catch( messagebox ~MSGBOX_FAILURE_OCCURED_WHILE_FREEZING_OBJ_POSITION~ title:~MSGBOX_FAILURE_OCCURED_WHILE_FREEZING_OBJ_POSITION_TITLE~)
			
			/* "Localization off" */  	
		) 	
		resumeEditing
		select Obj 	
	) 
	
	FreezePosition()
) 

--Set Rotation to Zero
MacroScript RotationToZero
	ButtonText:~ROTATIONTOZERO_BUTTONTEXT~ 
	Category:~ROTATIONTOZERO_CATEGORY~ 
	internalCategory:"Animation Tools" 
	Tooltip:~ROTATIONTOZERO_TOOLTIP~ 
(
	fn RotationToZero =
	(
		local Obj = Selection as array
		suspendEditing
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				if classof CurObj.rotation.controller == Rotation_Layer then
				(
					local active = CurObj.rotation.controller.active
				  	CurObj.rotation.controller[active].value = (quat 0 0 0 1)
				)
				else
				(
					CurObj.rotation.controller[2].x_rotation = 0
					CurObj.rotation.controller[2].y_rotation = 0
					CurObj.rotation.controller[2].z_rotation = 0
				)	
			)
			
			/* "Localization on" */  
	
			Catch( messagebox ~MSGBOX_ONE_OF_THE_OBJ_ROTATIONS_NEVER_FROZEN~ title:~MSGBOX_ONE_OF_THE_OBJ_ROTATIONS_NEVER_FROZEN_TITLE~)
		
			/* "Localization off" */  
		)
		resumeEditing
		select Obj
	)
	
	RotationToZero()
)

-- Position To Zero
MacroScript PositionToZero
	ButtonText:~POSITIONTOZERO_BUTTONTEXT~ 
	Category:~POSITIONTOZERO_CATEGORY~ 
	internalCategory:"Animation Tools" 
	Tooltip:~POSITIONTOZERO_TOOLTIP~ 
(
	fn PositionToZero =
	(
	
		local Obj = Selection as array
		suspendEditing
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				if classof CurObj.Position.controller == Position_Layer then
				(
					local active = CurObj.position.controller.active
					CurObj.Position.controller[active].value = (Point3 0 0 0)
				)
				else
				(
					CurObj.Position.controller[2].x_Position = 0
					CurObj.Position.controller[2].y_Position = 0
					CurObj.Position.controller[2].z_Position = 0
				)
			)
			/* "Localization on" */  
			
			Catch( messagebox ~MSGBOX_OBJ_POSITIONS_NEVER_FROZEN~ title:~MSGBOX_OBJ_POSITIONS_NEVER_FROZEN_TITLE~)
			
			/* "Localization off" */  	
		)
		resumeEditing
		select Obj
	)

	PositionToZero()
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCews9NDwYIVGWKcNT3StCXtBCr/cdxCNjD
-- iJxxPN462ALZe8ykqALz30/lKzo9LNAj+E9w6RMkXWiE3goF8MSx3MS4HojT/YWb
-- qMVMn6WdOfV7vld8AQ29YMD952RT4wH69Aw2toafg8UzbTtoFax0wemGc6n4KJ89
-- /EOTzDxIzW0oiDWOjz9zz5gYwGWhlP4Ud/QSrCJ03B39dk3FY+4Z6Volib7Dwo8S
-- h6KGoj+cebVH0IWVDPmBlJOxrK9StzauzXhqcYOOhqTAZoxQK5E7tuynkgax2vjd
-- tAuaveUe7zxtjME0EnpxVTaL40CPWRDd07Y72JtCZyWv+eq9F+D0
-- -----END-SIGNATURE-----